''' 3 - Intelligence artificielle'''

'''3-2 - Algorithme k-moyennes'''

## 3-2 - Algorithme k-moyennes

## Imports

from random import uniform as rdu
from random import randint as rdi
from matplotlib import pyplot as plt
plt.close('all')

## Création des données 2D

G = 5 # Nombre de groupes
PPG = 15 # Nombre de points par groupes
NP = G*PPG # Nombre de points
Largeur = 2 # Largeur groupe +-

Lx_2D = []
for g in range(G):
    X0 = rdi(10,90)
    Y0 = rdi(10,90)
    for p in range(PPG):
        X = X0 + rdi(-Largeur,Largeur)
        Y = Y0 + rdi(-Largeur,Largeur)
        Pt = [X,Y]
        Lx_2D.append(Pt)

def Affiche_2D(fig,LL,Col):
    ''' Affiche chaque liste de la liste LL avec la couleur respective de la liste Col '''
    plt.figure(fig)
    for i in range(len(LL)):
        L = LL[i]
        for X,Y in L:
            plt.plot(X,Y,'o',color=Col[i],markersize=2)
    plt.axis('scaled')
    plt.show()
    plt.pause(0.0001)

## Création des données 3D

G = 5 # Nombre de groupes
PPG = 15 # Nombre de points par groupes
NP = G*PPG # Nombre de points
Largeur = 2 # Largeur groupe +-

Lx_3D = []
for g in range(G):
    X0 = rdi(10,90)
    Y0 = rdi(10,90)
    Z0 = rdi(10,90)
    for p in range(PPG):
        X = X0 + rdi(-Largeur,Largeur)
        Y = Y0 + rdi(-Largeur,Largeur)
        Z = Z0 + rdi(-Largeur,Largeur)
        Pt = [X,Y,Z]
        Lx_3D.append(Pt)

''' Erreur
Unknown projection 3D
Import nécessaire sur certains ordinateurs
'''
from mpl_toolkits.mplot3d import Axes3D

def Affiche_3D(fig,LL,Col):
    ''' Affiche chaque liste de la liste LL avec la couleur respective de la liste Col '''
    plt.figure(fig)
    plt.axes(projection="3d")
    for i in range(len(LL)):
        L = LL[i]
        N = len(L)
        Lx = [L[k][0] for k in range(N)]
        Ly = [L[k][1] for k in range(N)]
        Lz = [L[k][2] for k in range(N)]
        plt.plot(Lx,Ly,Lz,'o',color=Col[i],markersize=2)
    plt.show()
    plt.pause(0.0001)

## Choix de l'application

Lx = Lx_3D
Affiche = Affiche_3D

Affiche(1,[Lx],['r'])

## Algorithme k-moyennes